using System;
using System.Reflection;

namespace gov.va.med.VBECS.VistaLinkServer.Core
{
	/// <summary>
	/// Summary description for RpcManager
	/// </summary>
	public class RpcManager : IDisposable
	{
		AppDomain _foreignCodeDomain;
	
		/// <summary>
		/// Constructor
		/// </summary>
		protected RpcManager()
		{		
			_foreignCodeDomain = AppDomain.CreateDomain( "VistALink RPC Server Foreign Code Domain" );
		}

		/// <summary>
		/// ExecutePublishedProcedure
		/// </summary>
        /// <param name="publishedProcedure"></param>
		/// <param name="evidence"></param>
		/// <param name="parameters"></param>
		/// <returns></returns>
        protected object ExecutePublishedProcedure(PublishedProcedure publishedProcedure, CallerSecurityEvidence evidence, object[] parameters)
		{
            if (publishedProcedure == null)
				throw( new ArgumentNullException( "publishedProcedure" ) );

			if( evidence == null )
				throw( new ArgumentNullException( "evidence" ) );

            publishedProcedure.SecurityInfo.Verify(evidence);

            //load this assembly/ type into the new domain
            var runner =
                (RemoteRunner)_foreignCodeDomain.CreateInstanceFromAndUnwrap(
                Assembly.GetExecutingAssembly().Location,
                typeof(RemoteRunner).FullName);

            //other instance of this class in new domain loads dll
            return runner.LoadDll(publishedProcedure.AssemblyNameLocation, publishedProcedure.FullTypeName, publishedProcedure.MethodName, parameters);
		}

		///<Developers>
		///	<Developer>saic</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/30/2010</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="9098"> 
		///		<ExpectedInput>Valid</ExpectedInput>
		///		<ExpectedOutput></ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="9099"> 
		///		<ExpectedInput>Invalid</ExpectedInput>
		///		<ExpectedOutput></ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Dispose
		/// </summary>
		public void Dispose()
		{
			GC.SuppressFinalize( this );
			Dispose( true );
		}

		private void Dispose( bool disposing )
		{
			lock( this )
			{
				if( disposing )
				{
					if( _foreignCodeDomain != null )
						AppDomain.Unload( _foreignCodeDomain );
				}
				_foreignCodeDomain = null;
			}
		}

		///<Developers>
		///	<Developer>saic</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/30/2010</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="9100"> 
		///		<ExpectedInput>Valid</ExpectedInput>
		///		<ExpectedOutput></ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="9101"> 
		///		<ExpectedInput>Invalid</ExpectedInput>
		///		<ExpectedOutput></ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Destructor
		/// </summary>
		~RpcManager()
		{			
			Dispose( false );
		}
	}
}
